<?php
/**
 * Title: FAQ
 * Slug: spectra-one/faq
 * Categories: text
 * Keywords: faq
 */
?>

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|x-large","bottom":"var:preset|spacing|x-large"},"blockGap":"var:preset|spacing|medium"}},"backgroundColor":"quaternary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-quaternary-background-color has-background" style="padding-top:var(--wp--preset--spacing--x-large);padding-bottom:var(--wp--preset--spacing--x-large)"><!-- wp:heading -->
<h2 class="wp-block-heading"><?php esc_html_e( 'Frequently Asked Questions', 'spectra-one' ); ?></h2>
<!-- /wp:heading -->
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":5} -->
<h5 class="wp-block-heading"><?php esc_html_e( 'What is Full Site Editing?', 'spectra-one' ); ?></h5>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p><?php esc_html_e( 'Full Site Editing (FSE) is a feature in WordPress that allows users to visually design and customize their entire website, including the header, footer, and other template parts.', 'spectra-one' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:separator {"backgroundColor":"outline","className":"is-style-swt-separator-wide-thin-line"} -->
<hr class="wp-block-separator has-text-color has-outline-color has-alpha-channel-opacity has-outline-background-color has-background is-style-swt-separator-wide-thin-line"/>
<!-- /wp:separator -->
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":5} -->
<h5 class="wp-block-heading"><?php esc_html_e( 'What are some benefits of using Full Site Editing?', 'spectra-one' ); ?></h5>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p><?php esc_html_e( 'Full Site Editing provides a more user-friendly, streamlined approach to website design and customization. It allows users to see changes in real-time, provides more control over design elements, and enables developers to create more custom blocks and templates.', 'spectra-one' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:separator {"backgroundColor":"outline","className":"is-style-swt-separator-wide-thin-line"} -->
<hr class="wp-block-separator has-text-color has-outline-color has-alpha-channel-opacity has-outline-background-color has-background is-style-swt-separator-wide-thin-line"/>
<!-- /wp:separator -->
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":5} -->
<h5 class="wp-block-heading"><?php esc_html_e( 'Can I use Full Site Editing on my existing WordPress website?', 'spectra-one' ); ?></h5>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p><?php esc_html_e( 'Yes, you can use Full Site Editing on an existing WordPress website by installing a compatible theme that supports the feature.', 'spectra-one' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:separator {"backgroundColor":"outline","className":"is-style-swt-separator-wide-thin-line"} -->
<hr class="wp-block-separator has-text-color has-outline-color has-alpha-channel-opacity has-outline-background-color has-background is-style-swt-separator-wide-thin-line"/>
<!-- /wp:separator -->
<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":5} -->
<h5 class="wp-block-heading"><?php esc_html_e( 'Do I need to know how to code to use Full Site Editing?', 'spectra-one' ); ?></h5>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p><?php esc_html_e( 'No, Full Site Editing does not require knowledge of coding or web development. The drag-and-drop interface and pre-designed templates make it easy for users to create a professional-looking website without any coding experience.', 'spectra-one' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->